PORT = 13000
BUF = 65535	#udp
TIMEOUT = 5	#udp
ETHTPE = 0x0813
ETHTPE_B = b'\x08\x13'
IPPROTO = 183
LISTENADDR = "0.0.0.0"
LISTENADDR6 = "::"

SERVER_DB = 's_hosts.json'
CLIENT_DB = 'c_hosts.json'
RSNDB = 'rsn.db'

halg = 'SHA256'

d = b'\x00\x00'

ACCEPT_KEY_UPDATES = False
NEG_KEYS = False

RSNL = 12

WINDOW_SIZE = 10

#DH parameters
#DHL = 192
#p=0xFFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA237327FFFFFFFFFFFFFFFF
#g=2 # publicly known

# Using 1024 MODP group from https://tools.ietf.org/html/rfc5114#section-2.1
DHL = 128
p=0xB10B8F96A080E01DDE92DE5EAE5D54EC52C99FBCFB06A3C69A6A9DCA52D23B616073E28675A23D189838EF1E2EE652C013ECB4AEA906112324975C3CD49B83BFACCBDD7D90C4BD7098488E9C219A73724EFFD6FAE5644738FAA31A4FF55BCCC0A151AF5F0DC8B4BD45BF37DF365C1A65E68CFDA76D4DA708DF1FB2BC2E4A4371
g=0xA4D1CBD5C3FD34126765A442EFB99905F8104DD258AC507FD6406CFF14266D31266FEA1E5C41564B777E690F5504F213160217B4B01B886A5E91547F9E2749F4D7FBD7D3B9A92EE1909D0D2263F80A76A6A24C087A091F531DBF0A0169B6A28AD662A4D18E73AFA32D779D5918D08BC8858F4DCEF97C2A24855E6EEB22B3B2E5


def dataToHexString(data,output=False):
	val=""
	if type(data) is str:
		val=":".join("{:02x}".format(int(c)) for c in data.encode())
	if type(data) is bytes:
		val=":".join("{:02x}".format(int(c)) for c in data)
	if output:
		print(val)
	return val

def stringToHexData(data):
	val=b''
	if type(data) is str:
		b = " ".join(data.split(":"))
		val = bytes.fromhex(b)
	return val

from cryptography.hazmat.primitives import serialization

def printPublicKeyFromPrivate(key, elliptic):
	if elliptic:
		str = key.public_key().public_bytes(serialization.Encoding.PEM,serialization.PublicFormat.SubjectPublicKeyInfo).decode()
	else:
		str = key.publickey().exportKey().decode()
	return str

def printPublicKey(key, elliptic):
	if elliptic:
		str = key.public_bytes(serialization.Encoding.PEM,serialization.PublicFormat.SubjectPublicKeyInfo).decode()
	else:
		str = key.exportKey().decode()
	return str

def getPublicKey(key, elliptic):
	if elliptic:
		str = key.public_key().public_bytes(serialization.Encoding.PEM,serialization.PublicFormat.SubjectPublicKeyInfo)
	else:
		str = key.publickey().exportKey()
	return str
